/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.sets;

import Data_Structures.Structures.UBA;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.Obj_union;
import Game_Engine.GUI.Components.small.gui_handle;

public class Swap_Set
extends Obj {
    UBA<Obj> data = new UBA();

    @Override
    public void update() {
        this.handle_swaps();
    }

    private void handle_swaps() {
        gui_handle moving_elem = gui_handle.handle_held;
        int moving_index = this.getIndex(moving_elem);
        if (moving_index < 0) {
            return;
        }
        int len = this.data.size();
        int current_index = 0;
        while (current_index < len) {
            if (current_index != moving_index) {
                Obj o = this.data.get(current_index);
                int bounds_reduce = o.getH() / 2;
                boolean c1 = o.collision(o.x_start - (double)bounds_reduce, o.y_start - (double)bounds_reduce, moving_elem);
                boolean c2 = o.collision(o.x_start + (double)bounds_reduce, o.y_start + (double)bounds_reduce, moving_elem);
                if (c1 && c2) {
                    this.swap(current_index, moving_index);
                    o.revert();
                    return;
                }
            }
            ++current_index;
        }
    }

    private int getIndex(Obj input) {
        int len = this.data.size();
        int i = 0;
        while (i < len) {
            Obj o = this.data.get(i);
            if (o == input) {
                return i;
            }
            if (o instanceof Obj_union && ((Obj_union)o).contains(input)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void swap(int i1, int i2) {
        Obj o1 = this.data.get(i1);
        Obj o2 = this.data.get(i2);
        this.data.swap(i1, i2);
        double tempX = o1.x_start;
        double tempY = o1.y_start;
        o1.x_start = o2.x_start;
        o1.y_start = o2.y_start;
        o2.x_start = tempX;
        o2.y_start = tempY;
    }

    public void add(gui_handle o) {
        this.data.add(o);
    }
}

